/*
 * QrfeEM4325Tag.cpp
 *
 *  Created on: 08.10.2013
 *      Author: stefan.detter
 */

#include "../inc/tag/specific/QrfeEM4325Tag.h"

#include "../inc/QrfeReaderInterface.h"

QrfeEM4325Tag::QrfeEM4325Tag(QString tagId, QrfeGen2AdvancedManipulatorInterface* reader, QObject* parent)
	: QrfeGen2Tag(tagId, reader, parent)
{
}

QrfeEM4325Tag::~QrfeEM4325Tag()
{
}


QrfeGlobal::TMIResult QrfeEM4325Tag::getSensorData ( const QByteArray& passwd, bool sendUID, bool getNewSample, QByteArray& uid, QrfeEM4325Tag::SENSOR_DATA& sensorData, uint& utcTimeStamp )
{
	if(passwd.size() != 4)
    {
        return QrfeGlobal::TMI_ERROR;
    }

	QrfeGlobal::TMIResult res;

	m_gen2reader->getReaderInterface()->setAntennaPower(true);

	QByteArray handle;
    res = ((QrfeGen2AdvancedManipulatorInterface*)m_gen2reader)->getTagHandle(m_tagId, handle);
	if(res != QrfeGlobal::TMI_OK)
	{
		m_reader->getReaderInterface()->setAntennaPower(false);
		return res;
	}

	res = getSensorData(handle, passwd, sendUID, getNewSample, uid, sensorData, utcTimeStamp);

	m_reader->getReaderInterface()->setAntennaPower(false);

	return res;
}

QrfeGlobal::TMIResult QrfeEM4325Tag::getSensorData ( const QByteArray& handle, const QByteArray& passwd, bool sendUID, bool getNewSample, QByteArray& uid, QrfeEM4325Tag::SENSOR_DATA& sensorData, uint& utcTimeStamp )
{
	QrfeGlobal::TMIResult res;

	if(passwd.size() != 4)
    {
        return QrfeGlobal::TMI_ERROR;
    }

	QByteArray cmd;
	cmd.append((uchar)0xE0);
	cmd.append((uchar)0x01);

	uchar d = 0;
	d |= (sendUID)?0x80:0x00;
	d |= (getNewSample)?0x40:0x00;
	QByteArray txBits;
	txBits.append(d);

	bool headerBit = true;
	QByteArray rxBytes;

    res = ((QrfeGen2AdvancedManipulatorInterface*)m_gen2reader)->customGen2Command(handle, cmd, passwd, 2, txBits, headerBit, rxBytes);
	if(res != QrfeGlobal::TMI_OK)
	{
		return res;
	}

	if(headerBit == true || rxBytes.size() < 8)
	{
		return QrfeGlobal::TMI_ERROR;
	}

	uchar uidSize = 0;
	if(sendUID)
	{
		if((uchar)rxBytes.at(0) == 0xE0)
			uidSize = 8;
		else if((uchar)rxBytes.at(0) == 0xE1)
			uidSize = 10;
		else if((uchar)rxBytes.at(0) == 0xE2)
			uidSize = 12;
	}

	if(rxBytes.size() < (8+uidSize))
	{
		return QrfeGlobal::TMI_ERROR;
	}


	uid = rxBytes.mid(0, uidSize);
	QByteArray sensorDataBytes = rxBytes.mid(0+uidSize, 4);
	QByteArray utcBytes = rxBytes.mid(0+uidSize+4, 4);

	utcTimeStamp = 0;
	utcTimeStamp |= ((uint)((uchar)utcBytes.at(0))) << 24;
	utcTimeStamp |= ((uint)((uchar)utcBytes.at(1))) << 16;
	utcTimeStamp |= ((uint)((uchar)utcBytes.at(2))) << 8;
	utcTimeStamp |= ((uint)((uchar)utcBytes.at(3))) << 0;

	sensorData.lowBatteryAlarm 	= ((sensorDataBytes.at(0) & 0x80) != 0);
	sensorData.auxAlarm			= ((sensorDataBytes.at(0) & 0x40) != 0);
	sensorData.overTempAlarm	= ((sensorDataBytes.at(0) & 0x20) != 0);
	sensorData.underTempAlarm	= ((sensorDataBytes.at(0) & 0x10) != 0);
	sensorData.p3Input			= ((sensorDataBytes.at(0) & 0x08) != 0);
	sensorData.monitorEnabled	= ((sensorDataBytes.at(0) & 0x04) != 0);
	sensorData.simpleSensor		= ((sensorDataBytes.at(0) & 0x02) != 0);

	short tempValue = 0;
	if((sensorDataBytes.at(0)&0x01) != 0)
		tempValue |= 0xFF00;
	tempValue |= (uchar)sensorDataBytes.at(1);
	sensorData.temperature = tempValue * 0.25;

	sensorData.abortedTempMeasurements 	= (((uchar)sensorDataBytes.at(2)) & 0xFC) >> 2;
	sensorData.underTempCount 			= 0;
	sensorData.underTempCount 		   |= (((uchar)sensorDataBytes.at(2)) & 0x03) << 3;
	sensorData.underTempCount 		   |= (((uchar)sensorDataBytes.at(3)) & 0xE0) >> 5;
	sensorData.overTempCount			= (((uchar)sensorDataBytes.at(3)) & 0x1F);

	return QrfeGlobal::TMI_OK;
}
